# مپل مارکت – نسخه بازنویسی‌شده با داشبورد ادمین (Django)

این پروژه از صفر با جنگو بازنویسی شده تا **همه‌چیز داینامیک** باشد و از **دیتابیس** لود شود.  
داشبورد مدیریت اختصاصی در مسیر `/admin/` پیاده‌سازی شده و همچنین **Django Admin** پیش‌فرض هم در مسیر `/dj-admin/` در دسترس است.

## ویژگی‌ها
- مدیریت دسته‌بندی و محصول با **CRUD کامل** از داشبورد ادمین.
- بارگذاری تصویر شاخص و گالری برای محصولات.
- ویترین ساده (صفحه اصلی، صفحه دسته، صفحه محصول) که همه داده‌ها را از دیتابیس می‌خواند.
- داده‌های اولیه محصولات از پروژه‌ی NextJS شما استخراج و در `data/products.json` ذخیره شده و با دستور زیر به دیتابیس وارد می‌شود.
- ایجاد کاربر ادمین با نام کاربری/رمزعبور: **admin / admin**

## اجرای پروژه (Development)
```bash
python -m venv .venv
source .venv/bin/activate  # در ویندوز: .venv\Scripts\activate
pip install -r requirements.txt

python manage.py migrate
python manage.py init_maplemart   # ایجاد ادمین و ایمپورت محصولات + تصاویر
python manage.py runserver
```
سپس به آدرس‌های زیر مراجعه کنید:
- داشبورد ادمین: http://127.0.0.1:8000/admin/  (نام کاربری: admin، رمز: admin)
- پیشخوان Django: http://127.0.0.1:8000/dj-admin/
- ویترین سایت: http://127.0.0.1:8000/

## نکات
- تصاویر محصولات از پروژه‌ی قبلی (پوشه‌ی `public`) به مسیر `media/images/products` کپی شده و هنگام ایمپورت محصول، تصویر شاخص به `media/products` منتقل/کپی می‌شود.
- برای تغییر نام سایت، قالب‌ها و ... از پوشه‌ی `templates` استفاده کنید.
- این پروژه برای شروع Production نیاز به تنظیمات امنیتی بیشتر (SECRET_KEY، DEBUG=False، تنظیم استاتیک و ... ) دارد.
