from django.urls import path
from . import views
urlpatterns = [
    path("", views.dashboard, name="admin_dashboard"),
    path("login/", views.admin_login, name="admin_login"),
    path("logout/", views.admin_logout, name="admin_logout"),

    # Categories
    path("categories/", views.category_list, name="admin_categories"),
    path("categories/new/", views.category_create, name="admin_category_create"),
    path("categories/<int:pk>/edit/", views.category_edit, name="admin_category_edit"),
    path("categories/<int:pk>/delete/", views.category_delete, name="admin_category_delete"),

    # Products
    path("products/", views.product_list, name="admin_products"),
    path("products/new/", views.product_create, name="admin_product_create"),
    path("products/<int:pk>/edit/", views.product_edit, name="admin_product_edit"),
    path("products/<int:pk>/delete/", views.product_delete, name="admin_product_delete"),
     path("admin/users/", views.user_list, name="admin_users"),
]
