from django.contrib import admin
from .models import Category, Product, ProductImage
from .models import SiteSetting, NewsletterSubscriber
class ProductImageInline(admin.TabularInline):
    model = ProductImage
    extra = 1

@admin.register(Category)
class CategoryAdmin(admin.ModelAdmin):
    list_display = ("name","parent")
    search_fields = ("name",)

@admin.register(Product)
class ProductAdmin(admin.ModelAdmin):
    list_display = ("title","category","price","in_stock")
    list_filter = ("category","in_stock")
    search_fields = ("title","description","tags")
    inlines = [ProductImageInline]
from .models import SiteSetting
@admin.register(SiteSetting)
class SiteSettingAdmin(admin.ModelAdmin):
    list_display = ("site_name", "store_title", "updated_at")

@admin.register(NewsletterSubscriber)
class NewsletterSubscriberAdmin(admin.ModelAdmin):
    list_display = ("email", "created_at")
    search_fields = ("email",)
from .models import BlogPost, ContactMessage

@admin.register(BlogPost)
class BlogPostAdmin(admin.ModelAdmin):
    list_display = ("title", "is_published", "published_at")
    search_fields = ("title", "excerpt", "content")
    list_filter = ("is_published",)
    prepopulated_fields = {"slug": ("title",)}

@admin.register(ContactMessage)
class ContactMessageAdmin(admin.ModelAdmin):
    list_display = ("name", "email", "created_at")
    search_fields = ("name", "email", "message")
from django.contrib import admin
from .models import Order, OrderItem

class OrderItemInline(admin.TabularInline):
    model = OrderItem
    extra = 0
    readonly_fields = ("title", "unit_price", "qty", "line_total")

@admin.register(Order)
class OrderAdmin(admin.ModelAdmin):
    list_display = ("id", "name", "email", "total", "status", "created_at")
    list_filter = ("status", "created_at")
    search_fields = ("name", "email", "phone")
    inlines = [OrderItemInline]
from django.contrib import admin
from .models import ReviewCategory, ProductReview

@admin.register(ReviewCategory)
class ReviewCategoryAdmin(admin.ModelAdmin):
    list_display = ("name", "order")
    search_fields = ("name", )
    ordering = ("order", "name")
    prepopulated_fields = {"slug": ("name",)}

@admin.action(description="Mark selected reviews as Approved")
def make_approved(modeladmin, request, queryset):
    queryset.update(status="approved")

@admin.action(description="Mark selected reviews as Rejected")
def make_rejected(modeladmin, request, queryset):
    queryset.update(status="rejected")

@admin.register(ProductReview)
class ProductReviewAdmin(admin.ModelAdmin):
    list_display = ("id", "product", "display_name", "rating", "status", "created_at")
    list_filter = ("status", "rating", "categories", "created_at")
    search_fields = ("title", "body", "name", "email", "product__title")
    autocomplete_fields = ("product", "user", "categories")
    actions = (make_approved, make_rejected)
