from django import forms
from .models import Category, Product, ProductImage

class CategoryForm(forms.ModelForm):
    class Meta:
        model = Category
        fields = ["name", "description", "parent"]

class ProductForm(forms.ModelForm):
    class Meta:
        model = Product
        fields = ["title","description","price","unit","weight_grams","category","in_stock","stock_qty","rating","reviews_count","tags","thumbnail"]

class ProductImageForm(forms.ModelForm):
    class Meta:
        model = ProductImage
        fields = ["image","alt"]
