# Generated by Django 5.2.7 on 2025-10-19 07:43

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Category',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=120, unique=True, verbose_name='نام دسته')),
                ('slug', models.SlugField(blank=True, max_length=140, unique=True, verbose_name='نامک')),
                ('description', models.TextField(blank=True, verbose_name='توضیحات')),
                ('parent', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='children', to='catalog.category')),
            ],
            options={
                'verbose_name': 'دسته بندی',
                'verbose_name_plural': 'دسته بندی\u200cها',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='Product',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=200, verbose_name='عنوان')),
                ('slug', models.SlugField(blank=True, max_length=220, unique=True, verbose_name='نامک')),
                ('description', models.TextField(blank=True, verbose_name='توضیحات')),
                ('price', models.DecimalField(decimal_places=2, max_digits=12, verbose_name='قیمت')),
                ('unit', models.CharField(default='عدد', max_length=50, verbose_name='واحد')),
                ('weight_grams', models.PositiveIntegerField(default=0, verbose_name='وزن (گرم)')),
                ('in_stock', models.BooleanField(default=True, verbose_name='موجود')),
                ('stock_qty', models.PositiveIntegerField(default=100, verbose_name='تعداد موجود')),
                ('rating', models.FloatField(default=0.0, verbose_name='امتیاز')),
                ('reviews_count', models.PositiveIntegerField(default=0, verbose_name='تعداد نظرات')),
                ('tags', models.CharField(blank=True, max_length=300, verbose_name='تگ\u200cها (با , جدا شود)')),
                ('thumbnail', models.ImageField(blank=True, null=True, upload_to='products/', verbose_name='تصویر شاخص')),
                ('category', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='products', to='catalog.category', verbose_name='دسته')),
            ],
            options={
                'verbose_name': 'محصول',
                'verbose_name_plural': 'محصولات',
                'ordering': ['title'],
            },
        ),
        migrations.CreateModel(
            name='ProductImage',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('image', models.ImageField(upload_to='products/', verbose_name='تصویر')),
                ('alt', models.CharField(blank=True, max_length=200, verbose_name='ALT')),
                ('product', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='images', to='catalog.product')),
            ],
            options={
                'verbose_name': 'تصویر محصول',
                'verbose_name_plural': 'تصاویر محصول',
            },
        ),
    ]
