from django.contrib import admin as dj_admin
from django.urls import path, include
from django.conf import settings
from django.conf.urls.static import static


urlpatterns = [
    path("dj-admin/", dj_admin.site.urls),
    path("admin/", include("adminpanel.urls")),
    path("", include("storefront.urls")),

    # NEW:
    path("accounts/", include("django.contrib.auth.urls")),  # login/logout/password reset...
]

if settings.DEBUG:
    urlpatterns += static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)
    urlpatterns += static(settings.STATIC_URL, document_root=settings.STATIC_ROOT)