# storefront/forms.py
from django import forms

class ContactForm(forms.Form):
    name = forms.CharField(max_length=120, label="Name")
    email = forms.EmailField(label="Email")
    message = forms.CharField(label="Message", widget=forms.Textarea(attrs={"rows": 4}))
class CheckoutForm(forms.Form):
    name = forms.CharField(max_length=120, label="Full name")
    email = forms.EmailField(label="Email")
    phone = forms.CharField(max_length=30, label="Phone")

    address_line1 = forms.CharField(max_length=160, label="Address line 1")
    address_line2 = forms.CharField(max_length=160, label="Address line 2", required=False)
    city = forms.CharField(max_length=80, label="City")
    region = forms.CharField(max_length=80, label="State/Province")
    postal_code = forms.CharField(max_length=30, label="Postal code")
    country = forms.CharField(max_length=80, label="Country")

    notes = forms.CharField(widget=forms.Textarea(attrs={"rows": 3}), required=False, label="Notes")
from django import forms
from catalog.models import Order

class OrderStatusForm(forms.ModelForm):
    class Meta:
        model = Order
        fields = ["status"]
        labels = {"status": "Status"}
from django import forms
from catalog.models import ProductReview, ReviewCategory

class ProductReviewForm(forms.ModelForm):
    categories = forms.ModelMultipleChoiceField(
        queryset=ReviewCategory.objects.order_by("order", "name"),
        widget=forms.CheckboxSelectMultiple,
        required=False,
        label="Categories"
    )
    class Meta:
        model = ProductReview
        fields = ["rating", "title", "body", "categories", "name", "email"]
        labels = {
            "rating": "Rating (1–5)",
            "title": "Title",
            "body": "Review",
            "name": "Your name (if not signed in)",
            "email": "Email (if not signed in)",
        }
        widgets = {
            "rating": forms.NumberInput(attrs={"min": 1, "max": 5, "step": 1}),
            "title": forms.TextInput(attrs={"maxlength": 160}),
            "body": forms.Textarea(attrs={"rows": 4}),
        }
