# storefront/urls.py
from django.urls import path
from . import views
from . import admin_views
urlpatterns = [
    path("", views.home, name="home"),
    path("c/<slug:slug>/", views.category_view, name="category"),
    path("p/<slug:slug>/", views.product_detail, name="product_detail"),
    path("cart/", views.cart, name="cart"),
    path("p/<slug:slug>/add-to-cart/", views.add_to_cart, name="add_to_cart"),
    path("newsletter/subscribe/", views.newsletter_subscribe, name="newsletter_subscribe"),
    path("store/", views.store, name="store"),
    path("about/", views.about, name="about"),
    path("contact/", views.contact, name="contact"),
    path("blog/", views.blog, name="blog"),
    path("checkout/", views.checkout, name="checkout"),
    path("checkout/success/<int:order_id>/", views.checkout_success, name="checkout_success"),
    path("admin/users/", admin_views.user_list, name="admin_users"),
    path("admin/orders/", admin_views.order_list, name="admin_orders"),
    path("admin/orders/<int:order_id>/", admin_views.order_detail, name="admin_order_detail"),
    path("product/<slug:slug>/review/", views.add_review, name="add_review"),

    # NEW:
    path("accounts/signup/", views.signup, name="signup"),
    path("account/", views.account, name="account"),
]
